clear
set more off

use "wide_nekarda_through2013_mvs8.dta"

drop if lfs8==.

gen year=1982

forvalues i= 1982/2013 { 
	replace year = `i' if mdate1>=tm(`i'm1) & mdate1<=tm(`i'm12)
}


gen dur = 1 if udur1>=0 & udur1<=26 & !missing(udur1)
replace dur = 2 if udur1>26 & !missing(udur1)


drop if missing(dur)

gen employed = 1 if lfs8==1 
replace employed=0 if lfs8==2 | lfs8==3

gen olf = 1 if lfs8==3
replace olf=0 if lfs8==2 | lfs8==1

gen unemployed = 1 if lfs8==2
replace unemployed = 0 if lfs8==1 | lfs8==3

****Deeper dive into month 16 employed***************
***full time all four***
gen emp_and_hours = 1 if (lfs5==1 & lfs6 == 1 & lfs7==1 & lfs8==1) & ((hract5 >= 35 & !missing(hract5)) & (hract6 >= 35 & !missing(hract6)) & (hract7 >= 35 & !missing(hract7)) & (hract8 >= 35 & !missing(hract8)))

****worked all four, at least one part time****
replace emp_and_hours = 2 if (lfs5==1 & lfs6 == 1 & lfs7==1 & lfs8==1) & (hract5 < 35 & !missing(hract5) & hract5>=0 | hract6 < 35 & !missing(hract6) & hract6>=0 | hract7 < 35 & !missing(hract7) & hract7>=0 | hract8 < 35 & !missing(hract8) & hract8>=0 )

***worked less than four*****
replace emp_and_hours = 3 if lfs8==1 & ((lfs5!=1 & !missing(lfs5) & lfs5>0) | (lfs6!=1 & !missing(lfs6) & lfs6>0) | (lfs7!=1 & !missing(lfs7) & lfs7>0))
*replace emp_and_hours = 3 if lfs8==1 & (lfs5==2 | lfs5==3 | lfs6==2 | lfs6==3 | lfs7==2 | lfs7==3 | lfs8==2 | lfs8==3)




label define emp_and_hours 1 "4 months full time" 2 "4 months, some part-time" 3 "less than 4 months"
label values emp_and_hours emp_and_hours


gen round_wgt = round(sswgt1)

gen full_time = 1 if emp_and_hours==1 
replace full_time = 0 if missing(full_time) & !missing(emp_and_hours)


collapse (mean) olf employed full_time unemp [aweight = sswgt1], by(year dur) 

gen emp_full_steady = full_time * employed

*save "Figures9_10_and_11_BPEA.dta", replace
****Graphs formatted in excel*****

